<?php include '../function.php';?>
<?php include '../function2.php';?>

<?php
$db = new DB_con();

$id = $_GET['id'] ?? '';

$order = null;
if ($id) {
    $result = $db->fetchLogoById($id); // You must define this method
    if ($result && $result->num_rows > 0) {
        $order = $result->fetch_assoc();
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $logocode = $_GET['id'] ?? '';
    $username = $_SESSION['username'] ?? 'guest';
    $message = $_POST['message'] ?? '';
    $imagePath = '';
    $created_at = $updated_at = date('Y-m-d H:i:s');

    if (!empty($_FILES['image']['name'])) {
        $imgName = time() . '_' . basename($_FILES['image']['name']);
        $uploadDir = '../uploads/messages/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
        $targetPath = $uploadDir . $imgName;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
            $imagePath = 'uploads/messages/' . $imgName;
        }
    }

    $stmt = $db->dbh->prepare("INSERT INTO messages (logocode, username, message, image, created_at, updated_at) 
                               VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssss", $logocode, $username, $message, $imagePath, $created_at, $updated_at);
    $stmt->execute();

    // Redirect back (clean URL, remove msg= if exists)
    $redirectUrl = $_SERVER['HTTP_REFERER'] ?? "/logo/users/details.php?id=" . urlencode($logocode);
    $redirectUrl = preg_replace('/(\?|&)msg=[^&]*/', '', $redirectUrl);
    $redirectUrl = rtrim($redirectUrl, '?&');

    header("Location: $redirectUrl");
    exit;
}
?>

<?php include 'header.php';?>

<div class="main-content">
    

  <div class="container py-5">
      <h2 class="mb-4">Logo Request Details</h2>

      <?php if ($order): ?>
<div class="bg-white p-4 rounded shadow-sm">
    <div class="row mb-3 fw-bold text-center">
        <div class="col-md-4">Description</div>
        <div class="col-md-4">Before</div>
        <div class="col-md-4">After</div>
    </div>

    <div class="row g-4">
        <div class="col-md-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><strong>Order Code:</strong> <span class="text-primary"><?= htmlspecialchars($order['logocode']) ?></span></li>
                        <li class="list-group-item"><strong>Name:</strong> <?= htmlspecialchars($order['name']) ?></li>
                        <li class="list-group-item"><strong>Email:</strong> <?= htmlspecialchars($order['email']) ?></li>
                        
                        <li class="list-group-item"><strong>Category:</strong> <?= htmlspecialchars($order['cat']) ?></li>
                        <li class="list-group-item"><strong>Status:</strong> 
                            <span class="badge <?= $order['ext1'] === 'cancel' ? 'bg-warning text-dark' : 'bg-success' ?>">
                                <?= ucfirst($order['ext1']) ?>
                            </span>
                        </li>
                        <li class="list-group-item"><strong>Price:</strong> <span class="text-success">$<?= $order['price'] ?></span></li>
                        <li class="list-group-item"><strong>Date:</strong> <?= $order['date'] ?></li>
                        <li class="list-group-item"><strong>Payment:</strong> <?= $order['paytype'] ?></li>
<li class="list-group-item">
    <?php if ($order['ext1'] === 'cancel'): ?>
        Cancelled
    <?php elseif ($order['paytype'] === 'approved' || $order['paytype'] === 'protected'): ?>
        <!-- No cancel option shown -->
    <?php else: ?>
        <a href="cancel-request.php?id=<?= htmlspecialchars($order['logocode']) ?>" 
           onclick="return confirm('Are you sure you want to cancel this request?')">
           Cancel Request
        </a>
    <?php endif; ?>
</li>

                    </ul>

                </div>
            </div>
        </div>

        <div class="col-md-4 d-flex align-items-center justify-content-center">
            <div class="border rounded shadow-sm" style="width: 320px; height: 320px; overflow: hidden;">
                <a href="../uploads/<?= htmlspecialchars($order['file']) ?>" target="_blank">
    <img src="../uploads/<?= htmlspecialchars($order['file']) ?>" 
         alt="Before Logo" 
         style="width: 100%; height: 100%; object-fit: cover;">
</a>
            </div>
        </div>

        <div class="col-md-4 d-flex align-items-center justify-content-center">
            <div class="border rounded shadow-sm" style="width: 320px; height: 320px; overflow: hidden;">
                <a href="<?= file_exists("../uploads/preview/" . $order['ext3']) && !empty($order['ext3']) 
              ? "../uploads/preview/" . htmlspecialchars($order['ext3']) 
              : "../assets/preview.png" ?>" 
   target="_blank">
    <img src="<?= file_exists("../uploads/preview/" . $order['ext3']) && !empty($order['ext3']) 
                  ? "../uploads/preview/" . htmlspecialchars($order['ext3']) 
                  : "../assets/preview.png" ?>" 
         alt="After Preview" 
         style="width: 100%; height: 100%; object-fit: cover;">
</a>
            </div>
        </div>
    </div>


<?php if ($order['ext1'] === 'cancel'): ?>
    <br>
    <span class="badge bg-secondary">Cancelled</span>
    <p>This request has been cancelled. Payment and download options are disabled.</p>

<?php elseif ($order['paytype'] === 'approved'): ?>
    <br>
    <strong>Download Files:</strong>
    <a href="<?= htmlspecialchars($order['ext2']) ?>" target="_blank">
        <?= basename($order['ext2']) ?>
    </a>

    <br><br><br>
    <span class="badge bg-danger">NOTE:</span>
    This website has the right to sell this design to online customers.
    If you want to make your design private, click below:
    <a href="protect.php?logocode=<?= htmlspecialchars($order['logocode']) ?>" 
       class="btn btn-sm btn-primary"
       onclick="return confirm('This will deduct $2.5 from your balance and protect your logo.\nProceed?')">
       Agree & Pay $2.5 to Protect
    </a>

<?php elseif ($order['paytype'] === 'protected'): ?>
    <br>
    <strong>Download Files:</strong>
    <a href="../uploads/files/<?= htmlspecialchars($order['ext2']) ?>" target="_blank">
        <?= basename($order['ext2']) ?>
    </a>

<?php else: ?>
    <br>
    <span class="badge bg-danger">NOTE:</span>
    If you agree with our design, click below to approve and purchase:
    <a href="purchase.php?logocode=<?= htmlspecialchars($order['logocode']) ?>" 
       class="btn btn-sm btn-primary"
       onclick="return confirm('This will deduct from your balance and approve the logo.\nProceed?')">
       Agree & Approve to Pay
    </a>
<?php endif; ?>




</div>
<?php else: ?>
    <div class="alert alert-danger">No order found for ID: <?= htmlspecialchars($id) ?></div>
<?php endif; ?>

  <?php if (isset($_GET['msg']) && $_GET['msg'] === 'protected_success'): ?>
    <div class="alert alert-success">Success! Your design is now protected.</div>
<?php endif; ?>    
      <div class="mt-5">
          <h4 class="mb-3">Chat About This Logo</h4>

  <form action="" method="POST" enctype="multipart/form-data">
      <input type="hidden" name="_token" value="8LNgZIQnIUoR0XZoWZsHMegSEzWlAp5gSrWGyZTC">    <textarea name="message" class="form-control mb-2" placeholder="Type your message..."></textarea>
      <input type="file" name="image" accept=".jpg,.jpeg,.png" class="form-control mb-2">
      <button type="submit" class="btn btn-primary">Send</button>
  </form>

          
          <hr>
        
      </div>
  </div>
<section style="background-color: #f7f6f6;">
  <div class="container py-5">
    <div class="row d-flex justify-content-center">
      <div class="col-md-12 col-lg-10 col-xl-8">
<?php if (!empty($_GET['msg'])): ?>
<div class="popup-overlay" id="popup">
  <div class="popup-box">
    <span class="popup-close" onclick="document.getElementById('popup').style.display='none'">&times;</span>
    <h3>Success</h3>
    <p><?= htmlspecialchars($_GET['msg']) ?></p>
  </div>
</div>
<?php endif; ?>
            <?php
$logocode = $_GET['id'] ?? '';
$msgs = $db->dbh->prepare("SELECT * FROM messages WHERE logocode = ? ORDER BY id DESC");
$msgs->bind_param("s", $logocode);
$msgs->execute();
$result = $msgs->get_result();
?>

<h5 class="mt-5 mb-3">Conversation</h5>
<?php while ($row = $result->fetch_assoc()): ?>
<div class="card mb-3">
    <div class="card-body">
        <div class="d-flex flex-start">
            <img class="rounded-circle shadow-1-strong me-3"
                src="https://ui-avatars.com/api/?name=<?= urlencode($row['username']) ?>&background=random"
                alt="avatar" width="40" height="40" />
            <div class="w-100">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="text-primary fw-bold mb-0"><?= htmlspecialchars($row['username']) ?></h6>
                    <p class="mb-0 small"><?= date('M d, Y h:i A', strtotime($row['created_at'])) ?></p>
                </div>
                <p class="mb-1"><?= nl2br(htmlspecialchars($row['message'])) ?></p>
                <?php if ($row['image']): ?>
                    <img src="../<?= $row['image'] ?>" alt="attachment" class="img-fluid mt-2" style="max-width: 200px;">
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php endwhile; ?>



                  
                  
                  
                  
                  
                  
        
      </div>
    </div>
  </div>
</section>

</div>
<?php include 'footer.php';?>
