<?php
include '../function.php';
include '../function2.php';

$username = $_SESSION['username'] ?? '';
$logocode = $_GET['logocode'] ?? '';
$protectionCost = 2.55;

if (!$username || !$logocode) {
    echo "<div class='alert alert-danger'>Invalid access.</div>";
    exit;
}

$db = new DB_con();

// Check if logo exists and belongs to this user
$stmt = $db->dbh->prepare("SELECT * FROM logo_requests WHERE logocode = ? AND username = ?");
$stmt->bind_param("ss", $logocode, $username);
$stmt->execute();
$result = $stmt->get_result();
$logo = $result->fetch_assoc();

if (!$logo) {
    echo "<div class='alert alert-danger'>Logo not found.</div>";
    exit;
}

// If already protected
if ($logo['paytype'] === 'protected') {
    echo "<div class='alert alert-info'>This logo is already protected.</div>";
    exit;
}

// Check balance
$currentBalance = $db->getUserBalance($username);
if ($currentBalance < $protectionCost) {
    echo "<div class='alert alert-danger'>Insufficient balance. Please top up your account.</div>";
    exit;
}

// Deduct and protect
$db->deductProtectionFee($username, $protectionCost, $logocode);

// Redirect with message
header("Location: details.php?id=" . urlencode($logocode) . "&msg=protected_success");
exit;
?>