<?php ob_start(); include 'function.php'; ?>
<?php include 'function2.php'; ?>
<?php include 'function3.php';?>
<?php include 'header.php'; ?>

<?php
$db = new DB_con();

// Check login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// Get ticket ID
if (!isset($_GET['id'])) {
    echo "Invalid Ticket ID.";
    exit;
}
$ticketId = $_GET['id'];

// Fetch ticket
$ticket = $db->fetchTicketById($ticketId);
if (!$ticket) {
    echo "Ticket not found.";
    exit;
}

// Handle new reply
if ($_SERVER["REQUEST_METHOD"] == "POST" && !empty($_POST['message'])) {
    $replyBy = $_SESSION['role'] ?? 'admin'; // 'admin' or 'user'
    $db->insertTicketReply($ticketId, $_SESSION['username'], $_POST['message'], $replyBy);
    $db->updateTicketStatus($ticketId, $replyBy === 'admin' ? 'Admin-Replied' : 'User-Replied');
    header("Location: view_ticket.php?id=" . $ticketId);
    exit;
}

// Fetch replies
$replies = $db->fetchTicketReplies($ticketId);
?>

<div class="main-content p-4">

   <div class="ticket-info mb-4 border p-3 rounded bg-light">
    <h3 class="mb-3"><?= htmlspecialchars($ticket['subject']) ?></h3>
    <table class="table table-bordered w-100">
        <tr>
            <th style="width: 20%;">Message</th>
            <td><?= nl2br(htmlspecialchars($ticket['message'])) ?></td>
        </tr>
        <tr>
            <th>Status</th>
            <td><?= htmlspecialchars($ticket['status']) ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <td><?= date('d M, Y H:i', strtotime($ticket['created_at'])) ?></td>
        </tr>
        <?php if (!empty($ticket['file_path'])): ?>
        <tr>
            <th>Attachment</th>
            <td><a href="<?= htmlspecialchars($ticket['file_path']) ?>" target="_blank">View File</a></td>
        </tr>
        <?php endif; ?>
    </table>
</div>

    <div class="reply-box mt-4">
        <h4>Replies:</h4>
        <?php if (!empty($replies)): ?>
            <?php foreach ($replies as $r): ?>
                <div class="reply mb-3 p-2 border rounded" style="background-color: <?= ($r['replied_by'] ?? '') === 'admin' ? '#ffffff' : '#f8f9fa' ?>;">

                    <div class="meta">
                        <strong><?= htmlspecialchars($r['username'] ?? 'Unknown') ?></strong>
                         —
                        <?= date('d M Y, H:i', strtotime($r['created_at'])) ?>
                    </div>
                    <div class="mt-1"><?= nl2br(htmlspecialchars($r['message'])) ?></div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p>No replies yet.</p>
        <?php endif; ?>
    </div>

    <div class="reply-box mt-4">
        <form method="post">
            <label for="message"><strong>Your Reply:</strong></label><br>
            <textarea name="message" rows="4" cols="60" required></textarea><br><br>
            <button type="submit" class="btn btn-primary">Send Reply</button>
        </form>
    </div>

</div>

<?php include 'footer.php'; ?>
