<?php include 'function.php'; ?>
<?php include 'function2.php'; ?>
<?php include 'header.php'; ?>

<?php
$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name       = trim($_POST['name']);
    $username   = trim($_POST['username']);
    $email      = trim($_POST['email']);
    $phone      = trim($_POST['phone']);
    $country    = trim($_POST['country']);
    $city       = trim($_POST['city']);
    $password   = $_POST['password'];
    $confirm    = $_POST['password_confirmation'];

    // Basic validations
    if (empty($name))       $errors['name'] = 'Full name is required.';
    if (empty($username))   $errors['username'] = 'Username is required.';
    if (empty($email))      $errors['email'] = 'Email is required.';
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors['email'] = 'Invalid email format.';
    if (empty($phone))      $errors['phone'] = 'Phone is required.';
    if (empty($country))    $errors['country'] = 'Country is required.';
    if (empty($city))       $errors['city'] = 'City is required.';
    if (empty($password))   $errors['password'] = 'Password is required.';
    if ($password !== $confirm) $errors['password_confirmation'] = 'Passwords do not match.';

    // Insert if no errors
    if (empty($errors)) {
        $db = new DB_con();
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
        $ip = $_SERVER['REMOTE_ADDR'];

        $stmt = $db->dbh->prepare("INSERT INTO users (username, email, password, country, city, whatsappno, ipaddress, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())");
        $status = 1;
        $stmt->bind_param("sssssssi", $username, $email, $hashedPassword, $country, $city, $phone, $ip, $status);

        if ($stmt->execute()) {
            $success = true;
        } else {
            $errors['general'] = "Something went wrong. Try again.";
        }
    }
}
?>

<main>
  <section class="w-breadcrumb-area" style="background: url('assets/img/common/breadcrumb-bg.png') no-repeat center center/cover;"></section>

  <section class="py-110 bg-offWhite">
    <div class="container">
      <div class="bg-white rounded-3 p-3">
        <div class="row g-4">
          <div class="col-lg-6 p-3 p-lg-5">
            <div class="mb-40">
              <h2 class="section-title mb-2">Sign up</h2>
              <p class="section-desc">Welcome to Work Zone</p>
            </div>

            <?php if ($success): ?>
                <div class="alert alert-success">Account created successfully! <a href="login.php">Login here</a>.</div>
            <?php elseif (!empty($errors['general'])): ?>
                <div class="alert alert-danger"><?= $errors['general'] ?></div>
            <?php endif; ?>

            <form method="POST" action="">
              <div class="form-container">
                <div class="row gy-3">
                  <div class="form-input col-lg-12">
                    <label for="name" class="form-label">Full Name *</label>
                    <input type="text" name="name" value="<?= htmlspecialchars($_POST['name'] ?? '') ?>" class="form-control shadow-none" required>
                    <?php if (isset($errors['name'])): ?><small class="text-danger"><?= $errors['name'] ?></small><?php endif; ?>
                  </div>

                  <div class="form-input col-lg-12">
                    <label for="username" class="form-label">Username *</label>
                    <input type="text" name="username" value="<?= htmlspecialchars($_POST['username'] ?? '') ?>" class="form-control shadow-none" required>
                    <?php if (isset($errors['username'])): ?><small class="text-danger"><?= $errors['username'] ?></small><?php endif; ?>
                  </div>

                  <div class="form-input col-lg-12">
                    <label for="email" class="form-label">Email *</label>
                    <input type="email" name="email" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" class="form-control shadow-none" required>
                    <?php if (isset($errors['email'])): ?><small class="text-danger"><?= $errors['email'] ?></small><?php endif; ?>
                  </div>

                  <div class="form-input col-lg-12">
                    <label for="phone" class="form-label">Phone *</label>
                    <input type="text" name="phone" value="<?= htmlspecialchars($_POST['phone'] ?? '') ?>" class="form-control shadow-none" required>
                    <?php if (isset($errors['phone'])): ?><small class="text-danger"><?= $errors['phone'] ?></small><?php endif; ?>
                  </div>

                  <div class="form-input col-lg-6">
                    <label for="country" class="form-label">Country *</label>
                    <input type="text" name="country" value="<?= htmlspecialchars($_POST['country'] ?? '') ?>" class="form-control shadow-none" required>
                    <?php if (isset($errors['country'])): ?><small class="text-danger"><?= $errors['country'] ?></small><?php endif; ?>
                  </div>

                  <div class="form-input col-lg-6">
                    <label for="city" class="form-label">City *</label>
                    <input type="text" name="city" value="<?= htmlspecialchars($_POST['city'] ?? '') ?>" class="form-control shadow-none" required>
                    <?php if (isset($errors['city'])): ?><small class="text-danger"><?= $errors['city'] ?></small><?php endif; ?>
                  </div>

                  <div class="form-input col-lg-12">
                    <label for="password" class="form-label">Password *</label>
                    <input type="password" name="password" class="form-control shadow-none" required>
                    <?php if (isset($errors['password'])): ?><small class="text-danger"><?= $errors['password'] ?></small><?php endif; ?>
                  </div>

                  <div class="form-input col-lg-12">
                    <label for="password_confirmation" class="form-label">Confirm Password *</label>
                    <input type="password" name="password_confirmation" class="form-control shadow-none" required>
                    <?php if (isset($errors['password_confirmation'])): ?><small class="text-danger"><?= $errors['password_confirmation'] ?></small><?php endif; ?>
                  </div>
                </div>

                <div class="d-grid mt-4">
                  <button class="w-btn-secondary-lg">Create Account</button>
                </div>
              </div>
            </form>

            <div class="mt-3">
              <p class="text-center form-text">
                Already have an account? <a href="login.php">Login</a>
              </p>
            </div>
          </div>

          <div class="col-lg-6">
            <div class="login-img">
              <img src="assets/img/others/1.png" class="img-fluid w-100" alt="">
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</main>

<?php include 'footer.php'; ?>