<?php 
$db = new DB_con();

$username = $_SESSION['username'] ?? 'guest'; // fallback
$totalBalance = $db->getTotalBalance($username);
$currentBalance = $db->getCurrentBalance($username);
$approvedLogos = $db->getApprovedLogos($username);
$pendingLogos = $db->getPendingLogos($username);
$cancelledLogos = $db->getCancelledLogos($username);
$ticketCount = $db->getTicketCount($username);


?>

<div class="row row-cols-1 row-cols-md-3 row-cols-xl-6 g-4">

  <!-- 1. Total Balance -->
  <div class="col">
    <div class="card text-center">
      <div class="card-body">
        <h5 class="card-title">$<?= number_format($totalBalance, 2) ?></h5>
        <p class="card-text text-muted">Total Balance</p>
        <img src="../assets/img/dashboard/icon/icon-1.png" alt="" width="30px">
      </div>
    </div>
  </div>

  <!-- 2. Current Balance -->
  <div class="col">
    <div class="card text-center">
      <div class="card-body">
        <h5 class="card-title">$<?= number_format($currentBalance, 2) ?></h5>
        <p class="card-text text-muted">Current Balance</p>
        <img src="../assets/img/dashboard/icon/icon-2.png" alt="" width="30px">
      </div>
    </div>
  </div>

  <!-- 3. Approved Logos -->
  <div class="col">
    <div class="card text-center">
      <div class="card-body">
        <h5 class="card-title"><?= $approvedLogos ?></h5>
        <p class="card-text text-muted">Approved Logos</p>
        <img src="../assets/img/dashboard/icon/icon-5.png" alt="" width="30px">
      </div>
    </div>
  </div>

  <!-- 4. Pending Logos -->
  <div class="col">
    <div class="card text-center">
      <div class="card-body">
        <h5 class="card-title"><?= $pendingLogos ?></h5>
        <p class="card-text text-muted">Pending Logos</p>
        <img src="../assets/img/dashboard/icon/icon-4.png" alt="" width="30px">
      </div>
    </div>
  </div>

  <!-- 5. Cancelled Logos -->
  <div class="col">
    <div class="card text-center">
      <div class="card-body">
        <h5 class="card-title"><?= $cancelledLogos ?></h5>
        <p class="card-text text-muted">Cancelled Logos</p>
        <img src="../assets/img/dashboard/icon/icon-3.png" alt="" width="30px">
      </div>
    </div>
  </div>

  <!-- 6. Tickets -->
  <div class="col">
    <div class="card text-center">
      <div class="card-body">
        <h5 class="card-title"><?= $ticketCount ?></h5>
        <p class="card-text text-muted">Tickets</p>
        <img src="../assets/img/dashboard/icon/icon-6.png" alt="" width="30px">
      </div>
    </div>
  </div>
</div>