<?php 
include '../function.php';
include '../function2.php';

$username = $_SESSION['username'] ?? '';
$logocode = $_GET['logocode'] ?? '';

if (!$username || !$logocode) {
    $message = "Invalid access.";
    goto redirect_back;
}

$db = new DB_con();

// Get logo info
$stmt = $db->dbh->prepare("SELECT * FROM logo_requests WHERE logocode = ? AND username = ?");
$stmt->bind_param("ss", $logocode, $username);
$stmt->execute();
$result = $stmt->get_result();
$logo = $result->fetch_assoc();

if (!$logo) {
    $message = "Logo not found.";
    goto redirect_back;
}

$amount  = floatval($logo['price']);
$paytype = $logo['paytype'];

// Already paid?
if ($paytype === 'approved') {
    $message = "This logo is already approved.";
    goto redirect_back;
}

// Check balance
$currentBalance = $db->getUserBalance($username);
if ($currentBalance < $amount) {
    $message = "Insufficient balance. Please top up your account.";
    goto redirect_back;
}

// Deduct and mark as approved
$db->deductPurchase($username, $amount, $logocode);
$message = "Purchase successful! Your logo is now approved.";

redirect_back:
// base redirect url
$redirectUrl = $_SERVER['HTTP_REFERER'] ?? '/logo/users/';

// remove any old msg= if exists
$redirectUrl = preg_replace('/(\?|&)msg=[^&]*/', '', $redirectUrl);
$redirectUrl = rtrim($redirectUrl, '?&');

// append clean msg
$redirectUrl .= (strpos($redirectUrl, '?') === false ? '?' : '&') . 'msg=' . urlencode($message);

header("Location: $redirectUrl");
exit;