<?php include '../function.php';?>
<?php include '../function2.php';?>
<?php

$db = new DB_con();

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "Invalid ticket ID.";
    exit;
}

$ticketId = $_GET['id'];
$ticket = $db->fetchTicketById($ticketId);

if (!$ticket) {
    echo "Ticket not found.";
    exit;
}


if (isset($_POST['submit_reply'])) {
    $message = $_POST['message'];
    $username = $_SESSION['username'];
    $role = ($_SESSION['role'] === 'user') ? 'admin' : 'user';

    $db->insertTicketReply($ticket['id'], $username, $role, $message);
    $db->updateTicketStatus($ticket['id'], ($role === 'admin') ? 'Admin-Replied' : 'User-Replied');
    header("Location: view_ticket.php?id=" . $ticket['id']);
    exit;
}
?>

<?php include 'header.php';?>

<div class="main-content"><div class="container mt-5">
    <h2 class="mb-4">Ticket Details</h2>
    <table class="table table-bordered">
        <tr>
            <th>Subject</th>
            <td><?= htmlspecialchars($ticket['subject']) ?></td>
        </tr>
        <tr>
            <th>Status</th>
            <td><?= htmlspecialchars($ticket['status']) ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <td><?= date('d M, Y H:i', strtotime($ticket['created_at'])) ?></td>
        </tr>
        <tr>
            <th>Attachment</th>
            <td>
                <?php if (!empty($ticket['file_path'])): ?>
                    <a href="<?= htmlspecialchars($ticket['file_path']) ?>" target="_blank">View Attachment</a><br>
                    
                <?php else: ?>
                    No attachment.
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <th>Message</th>
            <td><blockquote class="blockquote"><?= nl2br(htmlspecialchars($ticket['message'])) ?></blockquote></td>
        </tr>
    </table>

    <?php $replies = $db->getTicketReplies($ticket['id']); ?>

   <h4>Replies</h4>
<?php while ($reply = $replies->fetch_assoc()): ?>
  <div style="border:1px solid #ccc; padding:10px; margin-bottom:10px; background-color: <?= ($reply['replied_by'] === 'admin') ? '#fff' : '#f9f9f9' ?>;">
    <strong>(<?= htmlspecialchars($reply['username']) ?>):</strong><br>
    <p><?= nl2br(htmlspecialchars($reply['message'])) ?></p>
    <small><?= $reply['created_at'] ?></small>
  </div>
<?php endwhile; ?>

<form method="post">
  <textarea name="message" rows="4" class="form-control" required></textarea>
  <input type="submit" name="submit_reply" value="Reply" class="btn btn-primary mt-2">
</form>

    <div class="mt-4">
        <a href="user-dashboard.php" class="btn btn-secondary">← Back to Dashboard</a>
    </div>
</div></div>


<?php include 'footer.php';?>
