
<?php include 'function.php';?>
<?php include 'function2.php';?>
<?php include 'function3.php';?>
<?php


if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'admin') {
    header("Location: http://localhost/logo/admix/login.php");
    exit();
}
?>
<?php


if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'admin') {
    header("Location: http://localhost/logo/admix/login.php");
    exit();
}

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "Invalid request.";
    exit;
}

$userId = intval($_GET['id']);
$db = new DB_con();

// Fetch user details
$stmt = $db->dbh->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user) {
    echo "User not found.";
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $email = $_POST['email'];
    $country = $_POST['country'];
    $state = $_POST['state'];
    $city = $_POST['city'];
    $whatsappno = $_POST['whatsappno'];
    $status = $_POST['status'];

    $db->updateUserById($userId, $username, $email, $country, $state, $city, $whatsappno, $status);
    header("Location: viewuser.php?id=$userId");
    exit();
}
?>
<?php include 'header.php';?>

<div class="main-content">
  <div class="container py-5">
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="mb-4">Edit User</h4>

      <form method="POST">
        <div class="row g-4">
          <div class="col-md-6">
            <label class="form-label">Username</label>
            <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" required>
          </div>

          <div class="col-md-4">
            <label class="form-label">Country</label>
            <input type="text" name="country" class="form-control" value="<?= htmlspecialchars($user['country']) ?>">
          </div>

          <div class="col-md-4">
            <label class="form-label">State</label>
            <input type="text" name="state" class="form-control" value="<?= htmlspecialchars($user['state']) ?>">
          </div>

          <div class="col-md-4">
            <label class="form-label">City</label>
            <input type="text" name="city" class="form-control" value="<?= htmlspecialchars($user['city']) ?>">
          </div>

          <div class="col-md-6">
            <label class="form-label">WhatsApp No</label>
            <input type="text" name="whatsappno" class="form-control" value="<?= htmlspecialchars($user['whatsappno']) ?>">
          </div>

          <div class="col-md-6">
            <label class="form-label">Status</label>
            <select name="status" class="form-select">
              <option value="active" <?= $user['status'] === 'active' ? 'selected' : '' ?>>Active</option>
              <option value="inactive" <?= $user['status'] === 'inactive' ? 'selected' : '' ?>>Inactive</option>
            </select>
          </div>
        </div>

        <div class="mt-4">
          <button type="submit" class="btn btn-primary">Save Changes</button>
          <a href="viewuser.php?id=<?= $user['id'] ?>" class="btn btn-secondary">Cancel</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include 'footer.php';?>
