<?php include '../function.php';?>
<?php include '../function2.php';?>

<?php
$db = new DB_con();

$username = $_SESSION['username'] ?? '';
$logos = $db->fetchAllLogosByUser($username); // New method you need to create
?>

<?php include 'header.php';?>

<div class="main-content">
    


            <!-- Content -->
            <div>
              <h3 class="text-24 fw-bold text-dark-300 mb-2">Pending Jobs</h3>
              <!-- Table -->
              <div class="overflow-x-auto">
                <div class="w-100">
                  <table class="w-100 dashboard-table">
    <thead class="pb-3">
        <tr>
          <th scope="col" class="ps-4">Order ID</th>
            <th scope="col" class="ps-4">Order Name</th>
            <th scope="col">Price</th>
            <th scope="col">Date</th>
            <th scope="col">Paytype</th>
            <th scope="col">Category</th>
            <th scope="col" class="text-start">Status</th>
            <th scope="col">Files</th>
            <th scope="col">Preview</th>
            <th scope="col">View</th>

     
        </tr>
    </thead>
    <tbody>
      
    <?php while ($row = $logos->fetch_assoc()): ?>
<tr class="
  <?= $row['ext1'] === 'cancel' ? 'status-row-cancel' : '' ?>
  <?= $row['paytype'] === 'approved' ? 'bg-lightblue' : '' ?>
    <?= $row['paytype'] === 'protected' ? 'bg-lightred' : '' ?>
">
  <td class="text-dark-200"><?= $row['logocode'] ?></td>
  <td>
    <div class="d-flex gap-3 align-items-center project-name">
        <div class="order-img">
            <img src="../uploads/<?= $row['file'] ?>" alt="">
        </div>
        <div>
            <a href="#" class="project-link"><?= htmlspecialchars($row['name']) ?></a>
        </div>
    </div>
  </td>
  <td class="text-dark-200">$<?= $row['price'] ?></td>
  <td class="text-dark-200"><?= $row['date'] ?></td>



  <td class="text-start">
    <?php if ($row['paytype'] === 'protected' || $row['paytype'] === 'approved'): ?>
        <span class="status-badge status-row-<?= $row['paytype'] ?>"><?= $row['paytype'] ?></span>
    <?php else: ?>
        <?= htmlspecialchars($row['paytype']) ?>
    <?php endif; ?>
</td>


  
  <td class="text-dark-200"><?= $row['cat'] ?></td>
  <td class="text-start">
    <?php if ($row['ext1'] === 'cancel'): ?>
        <span class="status-badge status-row-cancel2"><?= ucfirst($row['ext1']) ?></span>
    <?php elseif (empty($row['ext2']) || $row['ext2'] === 'nofiles'): ?>

        <span class="status-badge status-row-pending">Pending</span>
    <?php else: ?>
        <span class="status-badge status-row-complete">Complete</span>
    <?php endif; ?>
</td>
  <td class="text-dark-200"><?= empty($row['ext2']) || $row['ext2'] === 'nofiles' ? 'No files' : 'Files available' ?></td>
  <td class="text-dark-200">
    <?php if ($row['paytype'] === 'protected' || $row['paytype'] === 'approved'): ?>
        <span class="status-badge status-row-protected">
            <?= substr($row['ext3'], 0, 7) ?>...
        </span>
    <?php else: ?>
        <?= substr($row['ext3'], 0, 7) ?>
    <?php endif; ?>
</td>
  <td class="text-dark-200">
      <a href="/logo/users/details.php?id=<?= $row['logocode'] ?>">View Details</a>
  </td>

 
</tr>
<?php endwhile; ?>

    </tbody>
</table>

                </div>
              </div>
            </div>
          
</div>
<?php include 'footer.php';?>
